package jp.kawakubo;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name = "BASKET_ITEM")
public class BasketItem implements Serializable {

    private int id = 0;
    private Basket basket = null;
    private Meigara meigara = null;
    private int quantity = 0;

    public BasketItem() {
    }
    
    public BasketItem(int id,
            Basket basket,
            Meigara meigara,
            int quantity) {
        this.id = id;
        this.basket = basket;
        this.meigara = meigara;
        this.quantity = quantity;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name = "ID")
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @ManyToOne(targetEntity = Basket.class)
    @JoinColumn(name = "BASKET_ID",
        referencedColumnName = "ID")
    public Basket getBasket() {
        return basket;
    }

    public void setBasket(Basket basket) {
        this.basket = basket;
    }

    @ManyToOne(targetEntity = Meigara.class)
    @JoinColumn(name = "MEIGARA_ID",
        referencedColumnName = "ID")
    public Meigara getMeigara() {
        return meigara;
    }

    public void setMeigara(Meigara meigara) {
        this.meigara = meigara;
    }

    @Column(name = "QUANTITY")
    public int getQuantity() {
        return quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

}
